<?php include 'header-link.php'; ?>

<?php
// Ensure database connection exists
if (!isset($con)) {
    die("Database connection not established.");
}

// Query to get all bank information from the database
$sql = "SELECT id, bank_name, acc_name, acc_no, branch_name, address, country FROM bank_info ORDER BY id DESC";
$stmt = $con->prepare($sql);

// Check if the statement preparation is successful
if ($stmt === false) {
    die('Error preparing query: ' . $con->error);
}

$stmt->execute();
$stmt->bind_result($id, $bank_name, $acc_name, $acc_no, $branch_name, $address, $country);

// Check if the form has been submitted to delete a bank entry
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_id'])) {
    $delete_id = $_POST['delete_id'];

    // Before executing the DELETE query, close the previous SELECT statement
    $stmt->close(); // Close the SELECT statement

    // Prepare the DELETE query to remove the bank entry
    $delete_sql = "DELETE FROM bank_info WHERE id = ?";
    $delete_stmt = $con->prepare($delete_sql);

    // Check if the DELETE statement preparation was successful
    if ($delete_stmt === false) {
        die('Error preparing DELETE query: ' . $con->error);
    }

    // Bind the parameters and execute the query
    $delete_stmt->bind_param("i", $delete_id);
    
    if ($delete_stmt->execute()) {
        // Redirect back to the same page after successful deletion
        header("Location: bank-list.php"); 
        exit();
    } else {
        echo "Error deleting record: " . $delete_stmt->error;
    }

    // Close the DELETE statement
    $delete_stmt->close();
}

// Store the bank information in an array for display
$bank_info = [];
while ($stmt->fetch()) {
    $bank_info[] = [
        'id' => $id,
        'bank_name' => $bank_name,
        'acc_name' => $acc_name,
        'acc_no' => $acc_no,
        'branch_name' => $branch_name,
        'address' => $address,
        'country' => $country,
    ];
}

// Close the prepared statement for SELECT
$stmt->close();
?>

<main>
    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-center">
                                <i class="profile-icon fa-regular fa-building-columns"></i>
                            </div>

                            <h6 class="card-title text-center my-3">All Bank Information</h6>
                            <a class="btn btn-info m-3 d-block text-center" href="bank-info-add.php">Add New</a>

                            <!-- Search Bar to filter bank information -->
                            <input type="text" class="form-control mb-4" id="searchInput" placeholder="Search Bank Info..." onkeyup="filterOffers()">

                            <!-- List of Banks -->
                            <div class="offer-list" id="offerList">
                                <?php foreach ($bank_info as $info): ?>
                                    <div class="offer-card mb-3 p-4">
                                        <div class="row">
                                            <div class="col-md-12 text-left">
                                                <small class="fw-bold">Bank Name: <strong><?php echo htmlspecialchars($info['bank_name']); ?></strong></small><p>
                                                <small>Account Name: <?php echo htmlspecialchars($info['acc_name']); ?></small><p>
                                                <small>Account No: <strong><?php echo htmlspecialchars($info['acc_no']); ?></strong></small><p>
                                                <small>Branch Name: <?php echo htmlspecialchars($info['branch_name']); ?></small><p>
                                                <small>Address: <?php echo htmlspecialchars($info['address']); ?></small><p>
                                                <small>Country: <?php echo htmlspecialchars($info['country']); ?></small><p>

                                                <!-- Delete Form -->
                                            <div class="d-grid text-center">    
                                                <form action="" method="POST" style="display:inline;">
                                                    <input type="hidden" name="delete_id" value="<?php echo $info['id']; ?>">
                                                    <button type="submit" class="btn custom-button w-50 mx-auto" onclick="return confirm('Are you sure you want to delete this entry?')">
                                                        <i class="font fa-solid fa-trash"></i> Delete
                                                    </button>
                                                </form>
                                            </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<script>
// Filter bank info based on search input
function filterOffers() {
    const searchInput = document.getElementById('searchInput').value.toLowerCase();
    const offerCards = document.querySelectorAll('.offer-card');

    offerCards.forEach(card => {
        const offerText = Array.from(card.querySelectorAll('small')).map(small => small.textContent.toLowerCase()).join(' ');

        if (offerText.includes(searchInput)) {
            card.style.display = '';  // Show the card
        } else {
            card.style.display = 'none';  // Hide the card
        }
    });
}
</script>

</body>
</html>
